% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTDD.R
\name{CTDD}
\alias{CTDD}
\title{CTDD(CTD Distribution)}
\usage{
CTDD(seqs, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and the number of columns is 15*13.
}
\description{
This function computes the distribution part of \link{CTD}. It calculates fifteen values for each property.
For more information, please check the references.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
CTD_D<-CTDD(seqs=filePrs)

}
\references{
Dubchak, Inna, et al. "Prediction of protein folding class using global description of amino acid sequence." Proceedings of the National Academy of Sciences 92.19 (1995): 8700-8704.
}
