% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{spa_is_empty}
\alias{spa_is_empty}
\title{Check if a \code{pgeometry} object is empty}
\usage{
spa_is_empty(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object.}
}
\value{
A Boolean value that indicates if a \code{pgeometry} is empty.
}
\description{
\code{spa_is_empty()} checks whether a given \code{pgeometry} object is empty (i.e., if it does not contain components).
}
\details{
The \code{spa_is_empty()} function checks if a pgeometry object has any component or not. If the number of components of a \code{pgeometry} object is equal to 0, then
it returns \code{TRUE}. Otherwise, it returns \code{FALSE}.
}
\examples{
# Creating an empty plateau line object 
pgo1 <- create_empty_pgeometry("PLATEAULINE")

# Checking if it is empty
spa_is_empty(pgo1)

# Adding a component to it and checking if it still empty
comp <- create_component("LINESTRING(1 1, 2 2, 2 3)", 0.5)
pgo1 <- spa_add_component(pgo1, comp)
spa_is_empty(pgo1)  
}
