% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{brainview.t4}
\alias{brainview.t4}
\title{Visualize a list of colored meshes from four angles.}
\usage{
brainview.t4(
  coloredmeshes,
  background = "white",
  skip_all_na = TRUE,
  style = "default",
  draw_labels = FALSE,
  rgloptions = list(),
  rglactions = list(),
  draw_colorbar = FALSE
)
}
\arguments{
\item{coloredmeshes, }{list of coloredmesh. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{background}{string, background color passed to \code{\link{bg3d}}.}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'render' set to FALSE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style, }{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{draw_labels}{logical, whether to draw label text for the different views that show information on the view direction and hemisphere displayed in a subplot. Defaults to FALSE.}

\item{rgloptions, }{named list. Parameters passed to \code{\link{par3d}}. Defaults to the empty list.}

\item{rglactions, }{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE.}
}
\description{
Visualize a list of colored meshes from four angles.
}
\keyword{internal}
