% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_atlas_agg.R
\name{spread.values.over.annot}
\alias{spread.values.over.annot}
\title{Spread a single value for a region to all region vertices.}
\usage{
spread.values.over.annot(
  annot,
  region_value_list,
  value_for_unlisted_regions = NaN,
  warn_on_unmatched_list_regions = FALSE,
  warn_on_unmatched_atlas_regions = FALSE
)
}
\arguments{
\item{annot, }{annotation. The result of calling fs.read.annot.}

\item{region_value_list, }{named list of strings. Each name must be a region name from the annotation, and the value must be the value to spread to all region vertices.}

\item{value_for_unlisted_regions, }{numeric scalar. The value to assign to vertices which are part of atlas regions that are not listed in region_value_list. Defaults to NaN.}

\item{warn_on_unmatched_list_regions, }{logical. Whether to print a warning when a region occurs in the region_value_list that is not part of the given atlas (and the value assigned to this region is thus ignored in the output file and data). Defaults to FALSE.}

\item{warn_on_unmatched_atlas_regions, }{logical. Whether to print a warning when a region occurs in the atlas that is not part of the given region_value_list (and thus the vertices of the region will be assigned the value 'value_for_unlisted_regions' in the output file and data). Defaults to FALSE.}
}
\value{
named list with following entries: "spread_data": a vector of length n, where n is the number of vertices in the annotation. One could write this to an MGH or curv file for visualization. "regions_not_in_annot": list of regions which are not in the annotation, but in the region_value_list. Their values were ignored.
}
\description{
Given an annotation and a list of values (one per brain region), return data that has the values for each region mapped to all region vertices.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   annot = subject.annot(subjects_dir, 'subject1', 'lh', 'aparc');
   region_value_list = list("bankssts"=0.9, "precuneus"=0.7);
   morph_like_data =
   spread.values.over.annot(annot, region_value_list, value_for_unlisted_regions=0.0);
}

}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{label.to.annot}()},
\code{\link{regions.to.ignore}()},
\code{\link{spread.values.over.hemi}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.label.from.annot}()},
\code{\link{subject.lobes}()}
}
\concept{atlas functions}
