% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_dir.R
\name{with_dir}
\alias{with_dir}
\title{Execute Code in a Temporary Working Directory}
\usage{
with_dir(new, code)
}
\arguments{
\item{new}{The new working directory.}

\item{code}{Code to execute in the temporary working directory.}
}
\value{
The results of the evaluation of the \code{code} argument.
}
\description{
This is a verbatim copy of \code{withr::with_dir} from of \pkg{withr}'s
version 2.4.1.
I often need \pkg{withr} only to import \code{withr::with_dir}, which is a
really simple function. So I just hijack \code{withr::with_dir}.
}
\examples{
temp_dir <- file.path(tempfile())
dir.create(temp_dir)
with_dir(temp_dir, getwd())
}
\seealso{
Other operating system functions: 
\code{\link{file_copy}()},
\code{\link{file_save}()},
\code{\link{get_boolean_envvar}()},
\code{\link{get_run_r_tests}()},
\code{\link{is_installed}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_success}()},
\code{\link{is_windows}()},
\code{\link{view}()},
\code{\link{vim}()}
}
\concept{operating system functions}
