% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.R
\name{genFEVD}
\alias{genFEVD}
\title{Compute a forecast error vector decomposition in generalised VAR scheme.}
\usage{
genFEVD(est, n.ahead = 100, no.corr = F)
}
\arguments{
\item{est}{the VAR estimate from the vars package}

\item{n.ahead}{how many periods ahead should be taken into account}

\item{no.corr}{boolean if the off-diagonal elements should be set to 0.}
}
\value{
a matrix that corresponds to contribution of ith variable to jth variance of forecast
}
\description{
This function computes the standard forecast error vector decomposition given the 
estimate of the VAR.
There are common complaints and requests whether the computation is ok and why
it does not follow the original Pesaran Shin (1998) article. So let me clear two things
out. First, the \eqn{\sigma} in the equation on page 20 refers to elements of \eqn{\Sigma}, not standard
deviation. Second, the indexing is wrong, it should be \eqn{\sigma_jj} not \eqn{\sigma_ii}. Look, for example,
to Diebold and Yilmaz (2012) or ECB WP by Dees, Holly, Pesaran, and Smith (2007)
for the correct version.
}
\author{
Tomas Krehlik \email{tomas.krehlik@gmail.com}
}
