% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillovers.R
\name{spilloverRollingFft}
\alias{spilloverRollingFft}
\title{Computing rolling frequency spillover}
\usage{
spilloverRollingFft(func, data, p, type, window, n.ahead, partition, absolute,
  no.corr, table = F, cluster = NULL)
}
\arguments{
\item{func}{name of the function that returns FEVD for the estimtate est}

\item{data}{variable containing the dataset}

\item{p}{lags in the VAR estimate.}

\item{type}{which type of VAR to use, see help for VAR from vars package}

\item{window}{length of the window to be rolled}

\item{n.ahead}{how many periods ahead should the FEVD be computed, generally this number
should be high enough so that it won't change with additional period}

\item{partition}{defines the frequency partitions to which the spillover should be decomposed}

\item{absolute}{boolean defining whether to compute the within or absolute spillover}

\item{no.corr}{boolean parameter whether the off-diagonal in the covariance matrix should be
set to zero}

\item{table}{boolean whether the full spillover table should be returned}

\item{cluster}{either NULL for no parallel processing or the variable containing the cluster.}
}
\value{
A corresponding spillover value on a given freqeuncy band, ordering of bands corresponds to the ordering of original bounds.
}
\description{
This function computes the rolling spillover using the standard VAR estimate.
We implement the parallel version for faster processing. The window is of fixed window
and is rolled over the data. Interpretation of the other parameters is the same as in the
standard computation of spillover.
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
