% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{forest_theme}
\alias{forest_theme}
\title{Forest plot default theme}
\usage{
forest_theme(
  base_size = 12,
  base_family = "",
  ci_pch = 15,
  ci_col = "black",
  ci_lty = 1,
  legend_name = "Group",
  legend_position = "right",
  legend_value = "",
  xaxis_lwd = 0.6,
  xaxis_cex = 1,
  refline_lwd = 1,
  refline_lty = "dashed",
  refline_col = "grey20",
  vertline_lwd = 1,
  vertline_lty = "dashed",
  vertline_col = "grey20",
  summary_fill = "#4575b4",
  summary_col = "#4575b4",
  footnote_cex = 0.6,
  footnote_fontface = "plain",
  footnote_col = "black",
  ...
)
}
\arguments{
\item{base_size}{The size of text}

\item{base_family}{The font family}

\item{ci_pch}{Shape of the point estimation. It will be reused if the
forest plot is grouped.}

\item{ci_col}{Color of the CI. A vector of color should be provided for
the grouped forest plot. An internal color set will be if only not.}

\item{ci_lty}{Line type of the CI. A vector of line type should be provided
for the grouped forest plot.}

\item{legend_name}{Title of the legend.}

\item{legend_position}{Position of the legend, \code{"right"}, \code{"top"},
\code{"bottom"}.}

\item{legend_value}{Legend labels (expressions). A vector should be provided
for the grouped forest plot. A "Group 1" etc will be created if not a vector
for a grouped forest plot.}

\item{xaxis_lwd}{Line width for x-axis.}

\item{xaxis_cex}{Multiplier applied to font size for x-axis.}

\item{refline_lwd}{Line width for reference line.}

\item{refline_lty}{Line type for reference line.}

\item{refline_col}{Line color for the reference line.}

\item{vertline_lwd}{Line width for extra vertical line. A vector can be provided
for each vertical line, and the values will be recycled if no enough values are
given.}

\item{vertline_lty}{Line type for extra vertical line. Works same as \code{vertline_lwd}.}

\item{vertline_col}{Line color for the extra vertical line. Works same as \code{vertline_lwd}.}

\item{summary_fill}{Colour for filling the summary diamond shape.}

\item{summary_col}{Colour for borders of the summary diamond shape.}

\item{footnote_cex}{Multiplier applied to font size for footnote.}

\item{footnote_fontface}{The font face for footnote.}

\item{footnote_col}{Color of the footnote.}

\item{...}{Other parameters passed to table. See \code{\link[gridExtra]{tableGrob}}
for details.}
}
\value{
A list.
}
\description{
Default theme for the forest plot, but can pass other parameters. The
parameters will be passed to corresponding elements of the forest plot.
See \code{\link[grid]{gpar}} for details.
}
