% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huberwb.R
\name{huberwb}
\alias{huberwb}
\title{Calculate the volume with bark of trees using the Huber method}
\usage{
huberwb(df, di, section_length, tree, .groups = NA, di_mm_to_cm = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{di}{Quoted name of the section diameter  variable, in centimeters.}

\item{section_length}{Quoted name of the section length variable, in meters}

\item{tree}{Quoted name of the tree variable. used to differentiate the trees' sections. If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}

\item{.groups}{Optional argument. Quoted name(s) of additional grouping variables that can be added to differentiate subdivisions of the data. 
If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}

\item{di_mm_to_cm}{Boolean argument that, if \code{TRUE}, converts the di argument from milliliters to centimeters. Default: \code{FALSE}.}
}
\value{
Data frame with volume values by section.
}
\description{
Function used to calculate the volume with bark of trees using the Huber method.
This function has integration with dplyr, so it can be used inside a pipe, along with the
\code{group_by} function.
}
\examples{
library(forestmangr)
data("exfm8")
exfm8

# Calculate the volume with bark using the Huber method:
huberwb(exfm8,"di_wb", "sec_length", "TREE")

# Using pipes:
library(dplyr)

 exfm8 \%>\% 
 group_by(TREE) \%>\% 
 huberwb("di_wb", "sec_length")

}
\references{
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.
}
\seealso{
Complementary functions:
  \code{\link{huberwob}}, For calculation of volume without bark using the Huber method,
  \code{\link{smalianwb}}, for calculation of volume with bark using the Smalian method,
  \code{\link{smalianwob}}, for calculation of volume without bark the Smalian method.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
