% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_names.R
\name{check_names}
\alias{check_names}
\title{Check if character vector contains variable names}
\usage{
check_names(df, var_names, boolean = TRUE)
}
\arguments{
\item{df}{a data frame.}

\item{var_names}{Character vector to be compared with the data frame names.}

\item{boolean}{Boolean object used to define if the output is going to be a boolean object \code{TRUE} , or a string \code{FALSE}. Default: \code{TRUE}.}
}
\description{
Function used to check if a string, or a character vector contains variable names of a given data frame.
}
\details{
Function used to check if a string, or a character vector contains variable names of a given data frame. 
This functions is mainly used to error-proof other functions of this package,
}
\examples{
library(forestmangr)

check_names(iris, "Species")
check_names(iris, "Species", boolean = FALSE )

check_names(iris, c("Especies", "Setal.Width") )
check_names(iris, c("Especies", "Setal.Width"), boolean = FALSE)

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
