% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_per.R
\name{bias_per}
\alias{bias_per}
\title{Bias of an estimator in percentage}
\usage{
bias_per(df, y, yhat)
}
\arguments{
\item{df}{a data frame.}

\item{y}{Quoted name of the variable representing the observed values in the data frame. If a data frame is not provided, \code{y} can also be a numeric vector.}

\item{yhat}{Quoted name of the variable representing the estimated values in the data frame. If a data frame is not provided, \code{yhat} can also be a numeric vector.}
}
\value{
Numeric vector with the bias value, in percentage.
}
\description{
Function for calculating the bias of an estimator.
}
\details{
Function for calculating the bias of an estimator, given the observed values, and the estimated values.
}
\examples{
library(forestmangr)
data("exfm11")
exfm11

# Bias of an estimator, given the data frame and quoted variable names:
bias_per(exfm11, "TH", "TH_EST3")

# Bias of an estimator, given the vectors for observed and estimated values:
bias_per(y = exfm11$TH, yhat = exfm11$TH_EST3)

}
\seealso{
other statistics to evaluate estimators: 
  \code{\link{rmse_per}} for the Root mean square error of an estimator
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
\keyword{bias}
