% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure-of-accuracy.R
\name{measure-of-accuracy}
\alias{measure-of-accuracy}
\alias{MSPE}
\alias{measure-of-accuracy}
\alias{MAPE}
\title{Mean squared or absolute \eqn{h}-step ahead prediction errors}
\usage{
MSPE(X, predcoef, m1 = length(X)/10, m2 = length(X), P = 1, H = 1,
  N = c(0, seq(P + 1, m1 - H + 1)), trimLo = 0, trimUp = 0)

MAPE(X, predcoef, m1 = length(X)/10, m2 = length(X), P = 1, H = 1,
  N = c(0, seq(P + 1, m1 - H + 1)), trimLo = 0, trimUp = 0)
}
\arguments{
\item{X}{the data \eqn{X_1, \ldots, X_T}}

\item{predcoef}{the prediction coefficients in form of a list of an array
         \code{coef}, and two integer vectors \code{t}    and \code{N}. The two
       integer vectors provide the information for which indices \eqn{t} and
         segment lengths \eqn{N} the coefficients are to be interpreted;
\code{(m1-H):(m2-1)} has to be a subset of \code{predcoef$t}.
         if not provided the necessary coefficients will be computed using
         \code{\link{predCoef}}.}

\item{m1}{first index from the set in which the indices \eqn{t+h} shall lie}

\item{m2}{last index from the set in which the indices \eqn{t+h} shall lie}

\item{P}{maximum order of prediction coefficients to be used;
must not be larger than \code{dim(predcoef$coef)[1]}.}

\item{H}{maximum lead time to be used;
must not be larger than \code{dim(predcoef$coef)[3]}.}

\item{N}{vector with the segment sizes to be used, 0 corresponds to
           using 1, ..., t;
has to be a subset of predcoef$N.}

\item{trimLo}{percentage \eqn{\alpha_1} of lower observations to be trimmed away}

\item{trimUp}{percentage \eqn{\alpha_2} of upper observations to be trimmed away}
}
\value{
\code{MSPE} returns an object of type \code{MSPE} that has \code{mspe},
	       an array of size \code{H}\eqn{\times}\code{P}\eqn{\times}\code{length(N)},
        as an attribute, as well as the parameters \code{N}, \code{m1},
        \code{m2}, \code{P}, and \code{H}.
        \code{MAPE} analogously returns an object of type \code{MAPE} that
        has \code{mape} and the same parameters as attributes.
}
\description{
The function \code{MSPE} computes the empirical mean squared prediction
errors for a collection of \eqn{h}-step ahead, linear predictors
(\eqn{h=1,\ldots,H}) of observations \eqn{X_{t+h}}, where
\eqn{m_1 \leq t+h \leq m_2}, for two indices \eqn{m_1} and \eqn{m_2}.
The resulting array provides
\deqn{\frac{1}{m_{\rm lo} - m_{\rm up} + 1} \sum_{t=m_{\rm lo}}^{m_{\rm up}} R_{(t)}^2,}
with \eqn{R_{(t)}} being the prediction errors
\deqn{R_t := | X_{t+h} - (X_t, \ldots, X_{t-p+1}) \hat v_{N,T}^{(p,h)}(t) |,}
ordered by magnitude; i.e., they are such that \eqn{R_{(t)} \leq R_{(t+1)}}.
The lower and upper limits of the indices are
\eqn{m_{\rm lo} := m_1-h + \lfloor (m_2-m_1+1) \alpha_1 \rfloor} and
\eqn{m_{\rm up} := m_2-h - \lfloor (m_2-m_1+1) \alpha_2 \rfloor}.
The function \code{MAPE} computes the empirical mean absolute prediction
errors
\deqn{\frac{1}{m_{\rm lo} - m_{\rm up} + 1} \sum_{t=m_{\rm lo}}^{m_{\rm up}} R_{(t)},}
with \eqn{m_{\rm lo}}, \eqn{m_{\rm up}} and \eqn{R_{(t)}} defined as before.
}
\examples{
T <- 1000
X <- rnorm(T)
P <- 5
H <- 1
m <- 20
Nmin <- 20
pcoef <- predCoef(X, P, H, (T - m - H + 1):T, c(0, seq(Nmin, T - m - H, 1)))

mspe <- MSPE(X, pcoef, 991, 1000, 3, 1, c(0, Nmin:(T-m-H)))

plot(mspe, vr = 1, Nmin = Nmin)
}
