% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ofp.R
\name{ofp}
\alias{ofp}
\title{Calculate ozone formation potential}
\usage{
ofp(
  df,
  inunit = "ppbv",
  outunit = "ppbv",
  t = 25,
  p = 101.325,
  stcd = FALSE,
  sortd = TRUE,
  chn = FALSE,
  mtype = "usa",
  bvoc = TRUE
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{inunit}{input's unit for VOC concentration. A character vector from these options: "ugm" or "ppbv". 
"ugm" means ug/m3. "ppbv" means part per billion volumn. The default vaule is "ppbv".}

\item{outunit}{output's unit for VOC concentration. A character from these options: "ugm" or "ppbv". 
"ugm" means ug/m3. "ppbv" means part per billion volumn. The default vaule is "ppbv".}

\item{t}{Temperature, in Degrees Celsius, used to convert data in 
micrograms per cubic meter to standard conditions 
(25 Degrees Celsius, 101.325 kPa). By default, t equals to 25 Degrees Celsius.}

\item{p}{Pressure, in kPa, used to convert data in micrograms per cubic meter 
to standard conditions (25 Degrees Celsius, 101.325 kPa). 
By default, p equals to 101.325 kPa.}

\item{stcd}{logical. Does it output results in standard conditions? The default vaule is FALSE.}

\item{sortd}{logical value. It determines whether the VOC species
are sorted or not. By default, sortd has value "TRUE".
If TRUE, VOC species in time series will be arranged according to VOC group,
 relative molecular weight, and MIR value.}

\item{chn}{logical. Dose colnames present as Chinese? The default vaule is FALSE.}

\item{mtype}{text. "usa" for MIR value from USA, "chn" for MIR value from CHINA.}

\item{bvoc}{logical. Whether you want to list BVOC as a separate VOC group? The default vaule is TRUE.}
}
\value{
a list contains 5 tables:
MIR_Result: the matched MIR value results;
OFP_Result: the OFP time series of VOC by species;
OFP_Result_stat: the statistics of OFP of VOC by species;
OFP_Result_group: OFP the time series of VOC classified by groups;
OFP_Result_group_stat: the statistics of OFP of VOC according to major groups.
}
\description{
Calculate Ozone Formation Potential (OFP) of VOC time series.
Note: for Chinese VOC name, please also use English punctuation.
}
\details{
The CAS number is matched for each VOC speices (from column name), and the
Maximum Incremental Reactivity (MIR) value is matched through the CAS number and used for time series calculation. \cr
The MIR value comes from <https://ww2.arb.ca.gov/sites/default/files/classic/regact/2009/mir2009/mir10.pdf>, 
Zhang et al.(2021) <doi:10.5194/acp-21-11053-2021>.
}
\examples{
voc_ofp=ofp(voc)
summary(voc_ofp)
}
