% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_i.R
\name{fa_i}
\alias{fa_i}
\title{Generate a Font Awesome \verb{<i>} tag}
\usage{
fa_i(name, class = NULL, ...)
}
\arguments{
\item{name}{The name of the Font Awesome icon.}

\item{class}{Additional classes to customize the style of the icon (see the
usage examples for details on supported styles).}

\item{...}{Arguments passed to the \verb{<i>} tag of \link[htmltools:builder]{htmltools::tags}.}
}
\value{
An icon element.
}
\description{
The \code{fa_i()} function creates a Font Awesome \verb{<i>} tag and not an SVG as with
\code{\link[=fa]{fa()}}. The primary use case for \code{fa_i()} is for legacy Shiny applications
that use the \code{\link[shiny:icon]{shiny::icon()}} function. This function is called within a
\code{\link[shiny:icon]{shiny::icon()}} call and all HTML dependencies to support icon generation are
hosted in the \strong{fontawesome} package.
}
\examples{
if (interactive()) {

# Create a Font Awesome icon object
fa_i(name = "r-project")

}

}
