% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_full_market}
\alias{fmpc_price_full_market}
\title{Current Price for an Entire Market}
\usage{
fmpc_price_full_market(market = "etf")
}
\arguments{
\item{market}{Select a market to get current price for all securities:
'etf','commodity','euronext','nyse','amex','tsx','index','mutual_fund',
'nasdaq','crypto','forex'. Select a single market.}
}
\value{
data frame of current price
}
\description{
Enter a market to get last traded price with additional price metrics such as
50D and 200D avg price, volume, shares outstanding, etc. This does NOT
include a quote, such as bid/ask detail. Each market will return multiple
responses, but only one API call as made per market.
}
\examples{
\dontrun{

fmpc_set_token('FMPAPIKEY')
fmpc_price_full_market('index')
fmpc_price_full_market('forex')
fmpc_price_full_market() # Default is to 'etf'

}
}
