% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_functions.R
\name{ffi_read_PicarroG2301}
\alias{ffi_read_PicarroG2301}
\title{Read a Picarro G2301 data file}
\usage{
ffi_read_PicarroG2301(file, tz = "UTC")
}
\arguments{
\item{file}{Filename to read, character}

\item{tz}{Time zone of the file's time data, character (optional)}
}
\value{
A \code{\link{data.frame}} with the parsed data.
}
\description{
Read a Picarro G2301 data file
}
\examples{
f <- system.file("extdata/PicarroG2301-data.dat", package = "fluxfinder")
dat <- ffi_read_PicarroG2301(f)
dat <- ffi_read_PicarroG2301(f, tz = "EST") # specify time zone
}
\references{
\url{https://www.picarro.com/environmental/products/g2301_gas_concentration_analyzer}
}
