% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_flow_doc.R
\name{flow_doc}
\alias{flow_doc}
\title{Draw Flow Diagrams for an Entire Package}
\usage{
flow_doc(
  pkg = NULL,
  prefix = NULL,
  code = TRUE,
  narrow = FALSE,
  truncate = NULL,
  swap = TRUE,
  out = NULL,
  engine = c("nomnoml", "plantuml")
)
}
\arguments{
\item{pkg}{package name as a string}

\item{prefix}{prefix to use for special comments in our code used as block headers,
must start with \code{"#"}, several prefixes can be provided}

\item{code}{Whether to display the code in code blocks or only the header,
to be more compact, if \code{NA}, the code will be displayed only if no header
is defined by special comments}

\item{narrow}{\code{TRUE} makes sure the diagram stays centered on one column
(they'll be longer but won't shift to the right)}

\item{truncate}{maximum number of characters to be printed per line}

\item{swap}{whether to change \code{var <- if(cond) expr} into
\code{if(cond) var <- expr} so the diagram displays better}

\item{out}{path to output (\code{.html} or \code{.md}), if left \code{NULL} a temp \emph{html}
file will be created and opened.}

\item{engine}{either \code{"nomnoml"} (default) or \code{"plantuml"} (experimental), if
the latter, arguments \code{prefix}, \code{narrow}, and \code{code}}
}
\value{
Returns \code{NULL} invisibly (called for side effects).
}
\description{
Draw Flow Diagrams for an Entire Package
}
\details{
if \code{pkg} and \code{out} are both left \code{NULL}, a vignette \code{diagrams.md} will be built
in the root, so that \code{pkgdown::build_site} will use it as an additional page.
See also the vignette \emph{"Build reports to document functions and unit tests"}.
}
