% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmixmsm.R
\name{meanfinal_fmixmsm}
\alias{meanfinal_fmixmsm}
\title{Mean time to final state in a mixture multi-state model}
\usage{
meanfinal_fmixmsm(x, newdata = NULL, final = FALSE, B = NULL)
}
\arguments{
\item{x}{Object returned by \code{\link{fmixmsm}}, representing a multi-state
model built from piecing together mixture models fitted by
\code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{final}{If \code{TRUE} then the mean time to the final state is
calculated for each final state, by taking a weighted average of the mean
time to travel each pathway ending in that final state, weighted by the
probability of the pathway.   If \code{FALSE}  (the default) then a
separate mean is calculated for each pathway.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}
}
\value{
A data frame of mean times to absorption, by covariate values and
  pathway (or by final state)
}
\description{
Calculate the mean time from the start of the process to a final (or
"absorbing") state in a mixture multi-state model.  Models with cycles are
not supported.
}
