% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{pBetaBin}
\alias{pBetaBin}
\title{Beta-Binomial Distribution}
\usage{
pBetaBin(x,n,a,b)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{n}{single value for no of binomial trials}

\item{a}{single value for shape parameter alpha representing as a}

\item{b}{single value for shape parameter beta representing as b}
}
\value{
The output of \code{pBetaBin} gives cumulative probability  values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Beta-Binomial Distribution.
}
\details{
Mixing beta distribution with binomial distribution will create the Beta-Binomial
distribution. The probability function and cumulative probability function can be
constructed and are denoted below.

The cumulative probability function is the summation of probability function values

\deqn{P_{BetaBin}(x)= {n \choose x} \frac{B(a+x,n+b-x)}{B(a,b)} }
\deqn{a,b > 0}
\deqn{x = 0,1,2,3,...n}
\deqn{n = 1,2,3,...}

The mean, variance and over dispersion are denoted as
\deqn{E_{BetaBin}[x]= \frac{na}{a+b} }
\deqn{Var_{BetaBin}[x]= \frac{(nab)}{(a+b)^2} \frac{(a+b+n)}{(a+b+1)} }
\deqn{over dispersion= \frac{1}{a+b+1} }

Defined as  \code{B(a,b)} is the beta function.
}
\examples{
#plotting the random variables and probability values
col<-rainbow(5)
a<-c(1,2,5,10,0.2)
plot(0,0,main="Beta-binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dBetaBin(0:10,10,a[i],a[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dBetaBin(0:10,10,a[i],a[i])$pdf,col = col[i],pch=16)
}

dBetaBin(0:10,10,4,.2)$pdf    #extracting the pdf values
dBetaBin(0:10,10,4,.2)$mean   #extracting the mean
dBetaBin(0:10,10,4,.2)$var    #extracting the variance
dBetaBin(0:10,10,4,.2)$over.dis.para  #extracting the over dispersion value

#plotting the random variables and cumulative probability values
col<-rainbow(4)
a<-c(1,2,5,10)
plot(0,0,main="Cumulative probability function graph",xlab="Binomial random variable",
ylab="Cumulative probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:4)
{
lines(0:10,pBetaBin(0:10,10,a[i],a[i]),col = col[i])
points(0:10,pBetaBin(0:10,10,a[i],a[i]),col = col[i])
}
pBetaBin(0:10,10,4,.2)   #acquiring the cumulative probability values

}
\references{
Young-Xu, Y. & Chan, K.A., 2008. Pooling overdispersed binomial data to estimate event rate. BMC medical
research methodology, 8(1), p.58.

Available at: \url{http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=2538541&tool=pmcentrez&rendertype=abstract} .

Trenkler, G., 1996. Continuous univariate distributions. Computational Statistics & Data Analysis, 21(1), p.119.

Available at: \url{http://linkinghub.elsevier.com/retrieve/pii/0167947396900158} .

Hughes, G., 1993. Using the Beta-Binomial Distribution to Describe Aggregated Patterns of Disease
Incidence. Phytopathology, 83(9), p.759.

Available at: \url{http://www.apsnet.org/publications/phytopathology/backissues/Documents/1993Abstracts/Phyto_83_759.htm}
}
