% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fishtree_complete_phylogeny}
\alias{fishtree_complete_phylogeny}
\title{Get complete (stochastically-resolved) phylogenies from the Fish Tree of Life}
\usage{
fishtree_complete_phylogeny(species, rank,
  mc.cores = getOption("mc.cores", 1L))
}
\arguments{
\item{species}{(Optionally) subset the results based on a vector of species names.}

\item{rank}{(Optionally) subset the results based on the supplied taxonomic rank.}

\item{mc.cores}{Number of cores to use in \link[parallel]{mclapply} when subsetting the tree (default `1`)}
}
\value{
An object of class `"multiPhylo"`.
}
\description{
Retrieves a complete, stochastically-resolved phylogeny via the Fish Tree of Life API. If neither `species` nor `rank` are specified, returns the entire phylogeny.
}
\examples{
\dontrun{
tree <- fishtree_complete_phylogeny(rank = "Acanthuridae")
sampled_tips <- fishtree_phylogeny(rank = "Acanthuridae")$tip.label
all_tips <- tree[[1]]$tip.label
new_tips <- setdiff(all_tips, sampled_tips)
par(mfrow = c(2,2))
for (ii in 1:4) {
  plot(tree[[ii]], show.tip.label = FALSE, no.margin = TRUE)
  ape::tiplabels(pch = 19, col = ifelse(tree[[ii]]$tip.label \%in\% new_tips, "red", NA))
}
}
}
\references{
Rabosky, D. L., Chang, J., Title, P. O., Cowman, P. F., Sallan, L., Friedman, M., Kashner, K., Garilao, C., Near, T. J., Coll, M., Alfaro, M. E. (2018). An inverse latitudinal gradient in speciation rate for marine fishes. Nature, 559(7714), 392–395. doi:10.1038/s41586-018-0273-1

Enhanced polytomy resolution strengthens evidence for global gradient in speciation rate for marine fishes. \url{https://fishtreeoflife.org/rabosky-et-al-2018-update/}
}
