\name{pgen}
\alias{pgen}
\title{Probability of a Management Parameter Exceeding a Reference Point}
\description{
  Calculates the probability of a management value exceeding a reference point with or without error
}
\usage{
  pgen(est=NULL,limit=NULL,estSD=0,limSD=0,corr=0,dist=1,comp=1,nreps=10000)
}
\arguments{
  \item{est}{management value (mv) or vector containing individual parameter values from, say, bootstrap runs.}
  \item{limit}{reference point (rp) or vector containing individual reference point values from, say, bootstrap runs.}
  \item{estSD}{standard deviation of management value if a single value is used. Must be >0 if a single value
       is used. If a vector of individual values is provided, estSD is not used.}
  \item{limSD}{standard deviation of reference point if a single value is used. If a vector of individual values is
          provided, limSD is not used. limSD = 0 if the reference point is considered a point estimate (no error).}
  \item{corr}{correlation between est and limit.  Only used if est and limit are single values with error.}
  \item{dist}{assumed distribution of est or limit if they are single values with error. 1 = normal; 2 = log-normal.}
  \item{comp}{the direction of comparison:  1: mv < rp, 2: mv <= rp, 3: mv > rp, 4: mv >= rp.}
  \item{nreps}{the number of samples to draw to create normal or log-normal distributions. User should explore
         different sample sizes to determine if the probability obtained is stable.}  
}
\details{
  Randomization methods as approximations to Equations 1, 2 and 3 in Shertzer et al. (2008) are used to calculate 
  the probability that a management value with error (e.g., fishing mortality) passes a reference point without 
  (Eq. 1) or with (Eq. 2) error. Either may be represented by a single value and its associated standard deviations 
  or a vector of individual values that represent results from, say, bootstrap runs. If log-normal is assumed, mv and 
  rp and associated standard deviations must be in natural log-units (i.e., meanlog and sdlog).

  If the management value and reference point are specified as single values with standard deviations,
  samples of size \emph{nreps} are drawn randomly from the specified distribution parameterized with 
  \emph{est} and \emph{limit} and associated standard deviations. If \emph{corr}>0 (Eq. 3), then the \emph{est} and
  \emph{limit} distributions are drawn from a multivariate normal (function \emph{mvrnorm}) distribution. If log-normal 
  is assumed, function \emph{mvrnorm} is used with the meanlog and sdlog estimates and then output values are 
  bias-corrected and back-transformed.   

  If the management value and the reference point are represented by vectors of individual values, 
  the probability is calculated by tallying the number of management values that exceed (or pass) the 
  reference points and then dividing by number of est values*number of limit values.  If either the management value 
  or reference point is specified as a single value with standard deviation, then a vector of individual values of 
  size equal to the size of the other vector is generated by using the \emph{rnorm} or \emph{rlnorm} function 
  parameterized with the single value and its standard deviation.
}
\value{probability value of comparison}

\references{Shertzer, K. W., M. H. Prager, and E. K. Williams. 2008.  A probability-based approach to setting 
  annual catch levels. Fishery Bulletion 106: 225-232.}
\author{Gary A. Nelson, Massachusetts Division of Marine Fisheries \email{gary.nelson@mass.gov}}
\note{Chris Legault of the National Marine Fisheries Service, Woods Hole, MA provided R code for the randomization method
	and Daniel Hennen of the the National Marine Fisheries Service, Woods Hole, MA provided the R code for using 
	mvrnorm to obtain log-normal distributions. 
}
\examples{
 ## est = 2010 Spawning Stock Biomass of Striped Bass, limit = SSB Reference Point
  pgen(est=50548,limit=36881,estSD=5485,limSD=1901,corr=0.05,dist=1,comp=2,nreps=1000)
}
\keyword{misc}

