% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_lw.R
\name{find_lw}
\alias{find_lw}
\title{A function to find length-weight relationship parameters a and b}
\usage{
find_lw(sp, mirror = "us")
}
\arguments{
\item{sp}{A charachter value containing the species name}

\item{mirror}{Mirror for fishbase (eg. "de", "org", "us", etc.) Default is "us".}
}
\value{
A dataframe with means and standard deviations of 
length-weight parameters
}
\description{
A function to find estimates length-weight relationship parameters available on fishbase. It returns a list of means and standard deviations of a and b obtained from:
*Froese, R., J. Thorson and R.B. Reyes Jr., 2013. A Bayesian approach for estimating length-weight relationships in fishes. J. Appl. Ichthyol. (2013):1-7.*
Please cite Froese et al. (2013), when using these values.
The default mirror for fishbase is set to "de", please change this if needed for your location
}
\examples{
\donttest{library(fishflux)
library(plyr)
# find length-weight relationship parameters for one species
find_lw("Lutjanus griseus")

# find length-weight relationship parameters for multiple species and return in dataframe
ldply(lapply(c("Chlorurus spilurus","Zebrasoma scopas"), find_lw))}

}
\keyword{bayesian}
\keyword{fish}
\keyword{fishbase}
\keyword{l-w}
\keyword{relationship}
