% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{intraday_transmission_capacity_EE_to_FI_RTD}
\alias{intraday_transmission_capacity_EE_to_FI_RTD}
\title{Real time intraday transmission capacity EE-FI}
\usage{
intraday_transmission_capacity_EE_to_FI_RTD(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains transmission capacity to be given
to intraday market EE-FI. After Elspot trades have been closed, real
time intraday capacity is equivalent to the allocated intraday capacity.
The real time capacity is updated after each intraday trade so that it
corresponds to real time situation.
}
\description{
Check https://data.fingrid.fi/en/dataset/real-time-transmission-capacity-to-be-given-to-intraday-market-ee-fi
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- intraday_transmission_capacity_EE_to_FI_RTD(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
