% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{down_regulation_price_balancing_energy_market}
\alias{down_regulation_price_balancing_energy_market}
\title{Down-regulation price in the Balancing energy market}
\usage{
down_regulation_price_balancing_energy_market(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains down-regulation price in the
Balancing energy market. The price of the cheapest regulating bid used
in the balancing power market during the particular hour; however, at
the most the price for price area Finland in Nord Pool Spot (Elspot FIN).
}
\description{
Check https://data.fingrid.fi/en/dataset/down-regulation-price-in-the-balancing-energy-market
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- down_regulation_price_balancing_energy_market(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
