% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spine_chart_utils.R
\name{create_datatable}
\alias{create_datatable}
\title{Data table supporting information}
\usage{
create_datatable(data, indicator, area_code, timeperiod, count, value,
  local_area_code, median_line_area_code, comparator_area_code, dps = 1)
}
\arguments{
\item{data}{a data frame to create the spine chart from. the data frame
should contain data for all area types included in the chart (eg, if
plotting for County & UA with a comparator of region and a median line for
national, the data frame should contain all of these data)}

\item{indicator}{unquoted field name of the field containing the indicator
labels. Take care as errors will occur where indicator labels are the same
but data exist for multiple sub-categories (for example, sex or age)}

\item{area_code}{unquoted field name where area codes are stored
(local_area_code, median_line_area_code and comparator_area_code, if using,
should all exist in this field)}

\item{timeperiod}{unquoted field name of the time period field}

\item{count}{unquoted field name where the count (numerator) is stored}

\item{value}{unquoted field name containing the values to be plotted}

\item{local_area_code}{string; the code of the area that the spine chart is
being drawn for}

\item{median_line_area_code}{string; area code for the median line. Defaults
to "E92000001" (England)}

\item{comparator_area_code}{string; area code for the comparator point.
Defaults to NA}

\item{dps}{number of decimal places to use in the data table}
}
\value{
A data frame containing the information that sits alongside the spine
  chart
}
\description{
Returns a data frame containing the data that sits next to the spine chart
}
