% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{S3-filearray}
\alias{S3-filearray}
\alias{[.FileArray}
\alias{[<-.FileArray}
\alias{[[.FileArray}
\alias{as.array.FileArray}
\alias{dim.FileArray}
\alias{length.FileArray}
\alias{max.FileArray}
\alias{min.FileArray}
\alias{range.FileArray}
\alias{sum.FileArray}
\title{'S3' methods for 'FileArray'}
\usage{
\method{[}{FileArray}(x, ..., drop = TRUE, reshape = NULL, strict = TRUE)

\method{[}{FileArray}(x, ...) <- value

\method{[[}{FileArray}(x, i)

\method{as.array}{FileArray}(x, reshape = NULL, drop = FALSE, ...)

\method{dim}{FileArray}(x)

\method{length}{FileArray}(x)

\method{max}{FileArray}(x, na.rm = FALSE, ...)

\method{min}{FileArray}(x, na.rm = FALSE, ...)

\method{range}{FileArray}(x, na.rm = FALSE, ...)

\method{sum}{FileArray}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a file array}

\item{drop}{whether to drop dimensions; see topic \code{\link[base]{Extract}}}

\item{reshape}{a new dimension to set before returning subset results; default is \code{NULL} (use default dimensions)}

\item{strict}{whether to allow indices to exceed bound; currently only accept \code{TRUE}}

\item{value}{value to substitute}

\item{i, ...}{index set, or passed to other methods}

\item{na.rm}{whether to remove \code{NA} values during the calculation}
}
\description{
These are 'S3' methods for 'FileArray'
}
\section{Functions}{
\itemize{
\item \code{[.FileArray}: get element by position

\item \code{[<-.FileArray}: assign array values

\item \code{[[.FileArray}: get element by index

\item \code{as.array.FileArray}: converts file array to native array in R

\item \code{dim.FileArray}: get dimensions

\item \code{length.FileArray}: get array length

\item \code{max.FileArray}: get max value

\item \code{min.FileArray}: get min value

\item \code{range.FileArray}: get value range

\item \code{sum.FileArray}: get summation
}}

