% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor2cov.R
\name{cor2cov}
\alias{cor2cov}
\title{Correlation Matrix to Covariance Matrix Conversion}
\usage{
cor2cov(cor.mat, sd, discrepancy = 1e-05)
}
\arguments{
\item{cor.mat}{the correlation matrix to be converted}

\item{sd}{a vector that contains the standard deviations of the variables in the correlation matrix}

\item{discrepancy}{a neighborhood of 1, such that numbers on the main diagonal of the correlation matrix will be considered as equal to 1 if they fall in this neighborhood}
}
\description{
Function to convert a correlation matrix to a covariance matrix.
}
\details{
The correlation matrix to convert can be either symmetric or triangular. The covariance matrix returned is always a symmetric matrix.
}
\note{
The correlation matrix input should be a square matrix, and the length of sd should be equal to the number of variables in the correlation matrix (i.e., the number of rows/columns). Sometimes the correlation matrix input may not have exactly 1's on the main diagonal, due to, eg, rounding; discrepancy specifies the allowable discrepancy so that the function still considers the input as a correlation matrix and can proceed (but the function does not change the numbers on the main diagonal).
}
\author{
Ken Kelley (University of Notre Dame; (\email{KKelley@ND.Edu}) and Keke Lai (the \code{MBESS} package), with modifications by Dustin Fife \email{fife.dustin@gmail.com}.
}

