% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_test.R
\name{tt_test}
\alias{tt_test}
\title{Torus Translation Test to determine habitat associations of tree species.}
\usage{
tt_test(tree, habitat, sp = NULL, plotdim = NULL, gridsize = NULL)
}
\arguments{
\item{tree}{A dataframe; a ForestGEO \emph{tree} table (see details).}

\item{habitat}{Object giving the habitat designation for each
plot partition defined by \code{gridsize}. See \code{\link[=fgeo_habitat]{fgeo_habitat()}}.}

\item{sp}{Character sting giving any number of species-names.}

\item{plotdim, gridsize}{Plot dimensions and gridsize. If \code{NULL} (default)
they will be guessed, and a message will inform you of the chosen values.
If the guess is wrong, you should provide the correct values manually (and
check that your habitat data is correct).}
}
\value{
A list of matrices.
}
\description{
Determine habitat-species associations with code developed by Sabrina Russo,
Daniel Zuleta, Matteo Detto, and Kyle Harms.
}
\details{
This test only makes sense at the population level. We are interested in
knowing whether or not individuals of a species are aggregated on a habitat.
Multiple stems of an individual do not represent population level processes
but individual level processes. Thus, you should use data of individual trees
-- i.e. use a \emph{tree} table, and not a \emph{stem} table with potentially multiple
stems per tree.

You should only try to determine the habitat association for sufficiently
abundant species. In a 50-ha plot, a minimum abundance of 50 trees/species
has been used.
}
\section{Acknowledgments}{

Nestor Engone Obiang, David Kenfack, Jennifer Baltzer, and Rutuja
Chitra-Tarak provided feedback. Daniel Zuleta provided guidance.
}

\section{Interpretation of Output}{

\itemize{
\item \code{N.Hab.1}: Count of stems of the focal species in habitat 1.
\item \code{Gr.Hab.1}: Count of instances the observed relative density of the focal
species on habitat 1 was greater than the relative density based on the TT
habitat map.
\item \code{Ls.Hab.1}: Count of instances the observed relative density of the focal
species on habitat 1 was less than the relative density based on the TT
habitat map.
\item \code{Eq.Hab.1}: Count of instances the observed relative density of the focal
species on habitat 1 was equal to the relative density based on the TT
habitat map.
The sum of the \code{Gr.Hab.x}, \code{Ls.Hab.x}, and \code{Eq.Hab.x} columns for one habitat
equals the number of 20 x20 quads in the plot.
The \code{Rep.Agg.Neut} columns for each habitat indicate whether the species is
significantly repelled (-1), aggregated (1), or neutrally distributed (0) on
the habitat in question.
}

The probabilities associated with the test for whether these patterns are
statistically significant are in the \code{Obs.Quantile} columns for each habitat.
Note that to calculate the probability for \emph{repelled}, it is \emph{the value
given}, but to calculate the probability for \emph{aggregated}, it is \emph{one minus
the value given}.

Values of the \code{Obs.Quantile < 0.025} means that the species is repelled from
that habitat, while values of the \code{Obs.Quantile > 0.975} means that the
species is aggregated on that habitat.
}

\section{References}{

Zuleta, D., Russo, S.E., Barona, A. et al. Plant Soil (2018).
\url{https://doi.org/10.1007/s11104-018-3878-0}.
}

\examples{
library(fgeo.tool)
assert_is_installed("fgeo.x")

# Example data
tree <- fgeo.x::tree6_3species
elevation <- fgeo.x::elevation

# Pick alive trees, of 10 mm or more
census <- filter(tree, status == "A", dbh >= 10)

# Pick sufficiently abundant species
pick <- filter(dplyr::add_count(census, sp), n > 50)

# Use your habitat data or create it from elevation data
habitat <- fgeo_habitat(elevation, gridsize = 20, n = 4)

# Defaults to using all species
as_tibble(
  tt_test(census, habitat)
)

Reduce(rbind, tt_test(census, habitat))

some_species <- c("CASARB", "PREMON")
result <- tt_test(census, habitat, sp = some_species)
summary(result)
}
\seealso{
\code{\link[=summary.tt_lst]{summary.tt_lst()}}, \code{\link[=summary.tt_df]{summary.tt_df()}}, \code{\link[=as_tibble]{as_tibble()}},
\code{\link[=fgeo_habitat]{fgeo_habitat()}}.

Other habitat functions: 
\code{\link{fgeo_habitat}()},
\code{\link{fgeo_topography}()}
}
\author{
Sabrina Russo, Daniel Zuleta, Matteo Detto, and Kyle Harms.
}
\concept{habitat functions}
