% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/originalRcode.R
\name{FFF_stream_jumpdetect}
\alias{FFF_stream_jumpdetect}
\title{Change detection using the Fixed Forgetting Factor method}
\usage{
FFF_stream_jumpdetect(stream, BL, ffparams)
}
\arguments{
\item{stream}{The stream of observations.}

\item{BL}{The burn-in length, used to estimate the mean and variance.}

\item{ffparams}{An \emph{unnamed} list of parameters for the FFF algorithm. 
                Consists of:
             \describe{
                 \item{\code{lambda}}{The value of the fixed forgetting
                                      factor (FFF). Should be in the range 
                                      [0,1].}

                 \item{\code{p}}{The value of the significance threshold, 
                                 which was later renamed \code{alpha} 
                                 (in the paper, not in this function).}
             
                 \item{\code{resettozero}}{A flag; if it zero, then the
                                           ffmean will be reset to zero  
                                           after each change. Usually set 
                                           to 1 (i.e. do not reset).}
             
                 \item{\code{u_init}}{The initial value of \code{u}. 
                                      Should be set to 0.}
             
                 \item{\code{v_init}}{The initial value of \code{v}. 
                                      Should be set to 0.}
             
                 \item{\code{w_init}}{The initial value of \code{w}. 
                                      Should be set to 0.}
             
                 \item{\code{ffmean_init}}{The initial value of the 
                                           forgetting factor mean,
                                           \code{ffmean}.
                                           Should be set to 0.}
             
                 \item{\code{ffvar_init}}{The initial value of the 
                                           forgetting factor variance, 
                                           \code{ffvar}.
                                           Should be set to 0.}
             
                     }}
}
\value{
A vector of estimated changepoints.
}
\description{
Original implementation in R of FFF change detector, but now
}
\keyword{internal}

