% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initAFFMeanCD}
\alias{initAFFMeanCD}
\title{Initialisation of AFF change detector}
\usage{
initAFFMeanCD(alpha, eta = 0.01, BL = 50)
}
\arguments{
\item{alpha}{The value of the significance level. 
There is no default value on purpose - it must 
be specified by the user.}

\item{eta}{The value of the step-size in the gradient descent. 
Default is \code{eta=0.01}.}

\item{BL}{The length of the burn-in region. Default value is \code{BL=50}.}
}
\description{
This function makes it simple to initalise an FFF object.
}
\examples{
library(Rcpp)
affmeancd1 <- initAFFMeanCD(alpha=0.01)    # initialises with eta=0.01, 
                                           # and BL=50

affmeancd2 <- initAFFMeanCD(alpha=0.005, eta=0.1,  BL=100) 

}

