% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/originalRcodePrechange.R
\name{EWMA_stream_jumpdetect_prechange}
\alias{EWMA_stream_jumpdetect_prechange}
\title{EWMA change detection for a stream in R with known prechange parameters}
\usage{
EWMA_stream_jumpdetect_prechange(stream, BL, params, mu0, sigma0)
}
\arguments{
\item{stream}{The stream of observations.}

\item{BL}{The burn-in length - this won't actually be used, but is
kept for historical reasons.}

\item{params}{A list of parameters for the EWMA algorithm. Consists of
             \describe{
                 \item{\code{r}}{A control parameter which controls
                                 the rate of downweighting.}

                 \item{\code{L}}{A control parameter which determines 
                                 the width of the control limits.}
             }}

\item{mu0}{The prechange mean, which is assumed known in this context}

\item{sigma0}{The prechange standard deviation, which is assumed known 
in this context}
}
\value{
A vector of estimated changepoints.
}
\description{
Original implementation in R of EWMA change detector, but now
expecting the prechange mean and variance to be specified.
}
\keyword{internal}

