# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Search for multiple changepoints in the mean using FFF
#'
#' Given a vector \code{x}, a threshold \code{alpha}, a value \code{lambda},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param lambda Value for the fixed forgetting factor in \eqn{(0,1)}.
#'
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#' 
#' @param BL Value for the burn-in length.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectFFFMeanMultiple <- function(x, lambda, alpha, BL) {
    .Call('ffstream_cpp_detectFFFMeanMultiple', PACKAGE = 'ffstream', x, lambda, alpha, BL)
}

#' Find the first changepoint in the mean using FFF
#'
#' Given a vector \code{x}, a threshold \code{alpha}, a value \code{lambda},
#' and a burn-in length \code{BL}, returns a list containing the single 
#' changepoint. Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param lambda Value for the fixed forgetting factor in \eqn{(0,1)}.
#'
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#' 
#' @param BL Value for the burn-in length.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{The first changepoint found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectFFFMeanSingle <- function(x, lambda, alpha, BL) {
    .Call('ffstream_cpp_detectFFFMeanSingle', PACKAGE = 'ffstream', x, lambda, alpha, BL)
}

#' Find the first changepoint in the mean using FFF, assuming prechange known
#'
#' Given a vector \code{x}, a value \code{lambda}, a threshold \code{alpha},
#' and values for known prechange mean and variance, returns a list containing 
#' the single changepoint. Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param lambda Value for the fixed forgetting factor in \eqn{(0,1)}.
#'
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#'
#' @param prechangeMean Value of known prechange mean.
#' 
#' @param prechangeSigma Value of known prechange standard deviation.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{The index of the first changepoint found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectFFFMeanSinglePrechange <- function(x, lambda, alpha, prechangeMean, prechangeSigma) {
    .Call('ffstream_cpp_detectFFFMeanSinglePrechange', PACKAGE = 'ffstream', x, lambda, alpha, prechangeMean, prechangeSigma)
}

#' Search for multiple changepoints in the mean using AFF
#'
#' Given a vector \code{x}, a threshold \code{alpha}, a step size \code{eta}, 
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#' 
#' @param eta Value for the step size in \eqn{(0,1)}.
#'
#' @param BL Value for the burn-in length.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectAFFMeanMultiple <- function(x, alpha, eta, BL) {
    .Call('ffstream_cpp_detectAFFMeanMultiple', PACKAGE = 'ffstream', x, alpha, eta, BL)
}

#' Find the first changepoint in the mean using AFF
#'
#' Given a vector \code{x}, a threshold \code{alpha}, a step size \code{eta}, 
#' and a burn-in length \code{BL}, returns a list containing the single 
#' changepoint. Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#' 
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#' 
#' @param eta Value for the step size in \eqn{(0,1)}.
#'
#' @param BL Value for the burn-in length.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{The index of the first changepoint found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectAFFMeanSingle <- function(x, alpha, eta, BL) {
    .Call('ffstream_cpp_detectAFFMeanSingle', PACKAGE = 'ffstream', x, alpha, eta, BL)
}

#' Find the first changepoint in the mean using AFF, assuming prechange known
#'
#' Given a vector \code{x}, a threshold \code{alpha}, a step size \code{eta}, 
#' and a burn-in length BL, returns a list containing the single changepoint.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param alpha Value for the significance threshold in \eqn{(0,1)}.
#' 
#' @param eta Value for the step size in \eqn{(0,1)}.
#' 
#' @param prechangeMean Value of known prechange mean.
#' 
#' @param prechangeSigma Value of known prechange standard deviation.
#' 
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{The index of the first changepoint found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectAFFMeanSinglePrechange <- function(x, alpha, eta, prechangeMean, prechangeSigma) {
    .Call('ffstream_cpp_detectAFFMeanSinglePrechange', PACKAGE = 'ffstream', x, alpha, eta, prechangeMean, prechangeSigma)
}

#' Search for multiple changepoints in the mean using CUSUM
#'
#' Given a vector \code{x}, control parameters \code{k} and \code{h},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param k control parameter for CUSUM
#'
#' @param h control parameter for CUSUM
#'
#' @param BL Value for the burn-in length.
#' 
#' @details CUSUM updates via: 
#'          \deqn{S_{j} = \max{0, S_{j-1} + (x_{j} - \mu)/ \sigma - k}}
#'          where \eqn{\mu} and \eqn{\sigma} are, respectively, the mean 
#'          and variance of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j}
#'          and \eqn{k} 
#'          is a control parameter for CUSUM. Then, a change is signalled
#'          if \eqn{S_j > h}, where \eqn{h} is the other control parameter.
#'          This is the formulation for using CUSUM to detect an increase
#'          in the mean; there is a similar formulation for detecting a 
#'          decrease, and usually CUSUM is two-sided (monitors for an 
#'          increase and a decrease in the mean).
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectCUSUMMeanMultiple <- function(x, k, h, BL) {
    .Call('ffstream_cpp_detectCUSUMMeanMultiple', PACKAGE = 'ffstream', x, k, h, BL)
}

#' Find the first changepoint in the mean using CUSUM
#'
#' Given a vector \code{x}, control parameters \code{k} and \code{h},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param k control parameter for CUSUM
#'
#' @param h control parameter for CUSUM
#'
#' @param BL Value for the burn-in length.
#' 
#' @details CUSUM updates via: 
#'          \deqn{S_{j} = \max{0, S_{j-1} + (x_{j} - \mu)/ \sigma - k}}
#'          where \eqn{\mu} and \eqn{\sigma} are, respectively, the mean 
#'          and variance of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j}
#'          and \eqn{k} 
#'          is a control parameter for CUSUM. Then, a change is signalled
#'          if \eqn{S_j > h}, where \eqn{h} is the other control parameter.
#'          This is the formulation for using CUSUM to detect an increase
#'          in the mean; there is a similar formulation for detecting a 
#'          decrease, and usually CUSUM is two-sided (monitors for an 
#'          increase and a decrease in the mean).
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectCUSUMMeanSingle <- function(x, k, h, BL) {
    .Call('ffstream_cpp_detectCUSUMMeanSingle', PACKAGE = 'ffstream', x, k, h, BL)
}

#' Find the first changepoint in the mean using CUSUM, assuming prechange 
#' known
#'
#' Given a vector \code{x}, control parameters \code{k} and \code{h},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param k control parameter for CUSUM
#'
#' @param h control parameter for CUSUM
#'
#' @param BL Value for the burn-in length.
#' 
#' @details CUSUM updates via: 
#'          \deqn{S_{j} = \max{0, S_{j-1} + (x_{j} - \mu)/ \sigma - k}}
#'          where \eqn{\mu} and \eqn{\sigma} are, respectively, the mean 
#'          and variance of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j}
#'          and \eqn{k} 
#'          is a control parameter for CUSUM. Then, a change is signalled
#'          if \eqn{S_j > h}, where \eqn{h} is the other control parameter.
#'          This is the formulation for using CUSUM to detect an increase
#'          in the mean; there is a similar formulation for detecting a 
#'          decrease, and usually CUSUM is two-sided (monitors for an 
#'          increase and a decrease in the mean).
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectCUSUMMeanSinglePrechange <- function(x, k, h, prechangeMean, prechangeSigma) {
    .Call('ffstream_cpp_detectCUSUMMeanSinglePrechange', PACKAGE = 'ffstream', x, k, h, prechangeMean, prechangeSigma)
}

#' Search for multiple changepoints in the mean using EWMA
#'
#' Given a vector \code{x}, control parameters \code{r} and \code{L},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param r control parameter for EWMA. Must be in range \eqn{[0,1]}.
#'
#' @param L control parameter for EWMA.
#'
#' @param BL Value for the burn-in length.
#' 
#' @details EWMA updates via: 
#'          \deqn{Z_{j} = (1-r) Z_{j-1} + r x_{j}}
#'          where \eqn{\mu} is the mean of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j} and \eqn{r} 
#'          is a control parameter for EWMA. Then, a change is signalled
#'          if \deqn{|Z_j - \mu|  > L \sigma_{Z_j}}, 
#'          where \eqn{L} is the other control parameter, and 
#'          \eqn{\sigma_{Z_j}} is a scaled version of the in-control
#'          variance \eqn{\sigma}.
#'          This is the formulation for using EWMA to detect an increase or
#'          decrease in the mean.
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectEWMAMeanMultiple <- function(x, r, L, BL) {
    .Call('ffstream_cpp_detectEWMAMeanMultiple', PACKAGE = 'ffstream', x, r, L, BL)
}

#' Find the first changepoint in the mean using EWMA
#'
#' Given a vector \code{x}, control parameters \code{r} and \code{L},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param r control parameter for EWMA. Must be in range \eqn{[0,1]}.
#'
#' @param L control parameter for EWMA.
#'
#' @param BL Value for the burn-in length.
#' 
#' @details EWMA updates via: 
#'          \deqn{Z_{j} = (1-r) Z_{j-1} + r x_{j}}
#'          where \eqn{\mu} is the mean of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j} and \eqn{r} 
#'          is a control parameter for EWMA. Then, a change is signalled
#'          if \deqn{|Z_j - \mu|  > L \sigma_{Z_j}}, 
#'          where \eqn{L} is the other control parameter, and 
#'          \eqn{\sigma_{Z_j}} is a scaled version of the in-control
#'          variance \eqn{\sigma}.
#'          This is the formulation for using EWMA to detect an increase or
#'          decrease in the mean.
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectEWMAMeanSingle <- function(x, r, L, BL) {
    .Call('ffstream_cpp_detectEWMAMeanSingle', PACKAGE = 'ffstream', x, r, L, BL)
}

#' Find the first changepoint in the mean using EWMA, assuming prechange 
#' known
#'
#' Given a vector \code{x}, control parameters \code{r} and \code{L},
#' and a burn-in length \code{BL}, returns a list containing the changepoints.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param r control parameter for EWMA. Must be in range \eqn{[0,1]}.
#'
#' @param L control parameter for EWMA.
#'
#' @param BL Value for the burn-in length.
#' 
#' @details EWMA updates via: 
#'          \deqn{Z_{j} = (1-r) Z_{j-1} + r x_{j}}
#'          where \eqn{\mu} is the mean of the in-control stream, 
#'          \eqn{x_j} is the observation at time \eqn{j} and \eqn{r} 
#'          is a control parameter for EWMA. Then, a change is signalled
#'          if \deqn{|Z_j - \mu|  > L \sigma_{Z_j}}, 
#'          where \eqn{L} is the other control parameter, and 
#'          \eqn{\sigma_{Z_j}} is a scaled version of the in-control
#'          variance \eqn{\sigma}.
#'          This is the formulation for using EWMA to detect an increase or
#'          decrease in the mean.
#' 
#' @return A list with 
#' \describe{
#'             \item{\code{tauhat}}{A vector of the changepoints found.}
#'          }
#' 
#' 
#' @keywords internal
cpp_detectEWMAMeanSinglePrechange <- function(x, r, L, prechangeMean, prechangeSigma) {
    .Call('ffstream_cpp_detectEWMAMeanSinglePrechange', PACKAGE = 'ffstream', x, r, L, prechangeMean, prechangeSigma)
}

#' Compute the FFF mean of a vector
#'
#' Given a vector \code{x} and a value \code{lambda} for a fixed forgetting
#' factor, returns the value of the fixed forgetting factor mean
#' \eqn{\bar{x}_{N, \lambda}}, where \eqn{N} is the length of \code{x}.
#' Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param lambda Value for the fixed forgetting factor in \eqn{[0,1]}.
#' 
#' @keywords internal
cpp_computeFFFMean <- function(x, lambda) {
    .Call('ffstream_cpp_computeFFFMean', PACKAGE = 'ffstream', x, lambda)
}

#' Compute the AFF mean of a vector
#'
#' Given a vector \code{x} and a value \code{eta} for step size
#' in the stochastic gradient descent for the adaptive forgetting
#' factor, this returns the value of the fixed forgetting factor mean
#' \eqn{\bar{x}_{N, \overrightarrow{\lambda} }}, where \eqn{N} is the 
#' length of \code{x}. Algorithm is implemented in C++.
#'
#' @param x Vector of numeric values values.
#'
#' @param eta Value for the step size in the gradient descent step.
#' 
#' @keywords internal
cpp_computeAFFMean <- function(x, eta) {
    .Call('ffstream_cpp_computeAFFMean', PACKAGE = 'ffstream', x, eta)
}

computeOneSidedPvalueRcpp <- function(x_, a_, b_) {
    .Call('ffstream_computeOneSidedPvalueRcpp', PACKAGE = 'ffstream', x_, a_, b_)
}

combineTwoOneSidedPvaluesRcpp <- function(p1_, p2_) {
    .Call('ffstream_combineTwoOneSidedPvaluesRcpp', PACKAGE = 'ffstream', p1_, p2_)
}

convertPvalueToCorrectSideRcpp <- function(p_) {
    .Call('ffstream_convertPvalueToCorrectSideRcpp', PACKAGE = 'ffstream', p_)
}

computeTwoSidedPvalueRcpp <- function(x_, a_, b_) {
    .Call('ffstream_computeTwoSidedPvalueRcpp', PACKAGE = 'ffstream', x_, a_, b_)
}

computeStdNormCdf <- function(x_) {
    .Call('ffstream_computeStdNormCdf', PACKAGE = 'ffstream', x_)
}

makeTwoSidedPvalueOneSidedR <- function(p2_) {
    .Call('ffstream_makeTwoSidedPvalueOneSidedR', PACKAGE = 'ffstream', p2_)
}

