% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_autoplot_week.R
\name{autoplot.ff_simulation_week}
\alias{autoplot.ff_simulation_week}
\alias{plot.ff_simulation_week}
\title{Automatically Plot ff_simulation Object}
\usage{
autoplot.ff_simulation_week(object, type = c("luck", "points"), ...)

\method{plot}{ff_simulation_week}(x, ..., type = c("luck", "points"), y)
}
\arguments{
\item{object}{a \code{ff_simulation} object as created by \code{ff_simulate()}}

\item{type}{one of "luck" or "points"}

\item{...}{unused, required by autoplot generic}

\item{x}{A \code{ff_simulation_week} object.}

\item{y}{Ignored, required for compatibility with the \code{plot()} generic.}
}
\value{
a ggplot object
}
\description{
Creates automatic plots for wins, ranks, or points for an \code{ff_simulation} object as created by \code{ff_simulate()}.
}
\details{
Usage of this function/method requires the ggplot2 package and (for wins and points plots) the ggridges package.
}
\examples{
\donttest{

simulation <- .ffs_cache("foureight_sim_week.rds")

ggplot2::autoplot(simulation) # default is type = "luck"
ggplot2::autoplot(simulation, type = "points")
}

}
\seealso{
\code{vignette("basic")} for example usage
}
