% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_nflfastr.R
\name{nflfastr_rosters}
\alias{nflfastr_rosters}
\title{Import nflfastr roster data}
\usage{
nflfastr_rosters(seasons)
}
\arguments{
\item{seasons}{A numeric vector of seasons, earliest of which is 1999}
}
\value{
Data frame where each individual row represents a player in the roster of the given team and season
}
\description{
Fetches a copy of roster data from nflfastr's data repository.
The same input/output as nflfastr's fast_scraper_roster function.
}
\details{
If you have any issues with the output of this data, please open an issue in
the nflfastr repository.
}
\examples{
\donttest{
nflfastr_rosters(seasons = 2019:2020)
}

}
\seealso{
\url{https://nflfastr.com/reference/fast_scraper_roster.html}
}
