% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-theoretical-lmoments.R
\name{utils_theoretical_lmoments}
\alias{utils_theoretical_lmoments}
\title{Theoretical L-moments of Probability Distributions}
\usage{
utils_theoretical_lmoments(distribution, params)
}
\arguments{
\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{params}{Numeric vector of distribution parameters, in the order (location,
scale, shape). The length must be between 2 and 5, depending on the specified
\code{distribution} and \code{structure}.}
}
\value{
A numeric vector of with four elements:
\itemize{
\item \eqn{\lambda_1}: L-mean
\item \eqn{\lambda_2}: L-variance
\item \eqn{\tau_3}: L-skewness
\item \eqn{\tau_4}: L-kurtosis
}
}
\description{
Computes the first four L-moments and L-moment ratios for \emph{stationary} probability models.
}
\details{
The distributions \code{"GUM"}, \code{"NOR"}, \code{"GEV"}, \code{"GLO"}, and \code{"WEI"} have
closed-form solutions for the L-moments and L-moment ratios in terms of the parameters.
The distributions \code{"GNO"} and \code{"PE3"} use rational approximations of the L-moment ratios
from Hosking (1997). The L-moments ratios for the \code{"LNO"} and \code{"LP3"} distributions
are should be compared to the log-transformed data and are thus identical to the \code{"NOR"}
and \code{"PE3"} distributions respectively.
}
\examples{
utils_theoretical_lmoments("GEV", c(1, 1, 1))

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
