% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-sffa-fit.R
\name{plot_sffa_fit}
\alias{plot_sffa_fit}
\title{Plot Fitted Probability Distribution for S-FFA}
\usage{
plot_sffa_fit(results, show_line = TRUE, ...)
}
\arguments{
\item{results}{A fitted flood frequency model generated by \code{\link[=fit_lmoments]{fit_lmoments()}},
\code{\link[=fit_mle]{fit_mle()}} or \code{\link[=fit_gmle]{fit_gmle()}}.}

\item{show_line}{If \code{TRUE} (default), draw a fitted line through the data.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot showing:
\itemize{
\item The likelihood function of the distribution plotted vertically on the left panel.
\item The data, connected with a line if \code{show_line == TRUE}, on the right panel.
}
}
\description{
Generates a plot showing the probability density of a stationary model (left panel)
and the data (right panel).
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
results <- fit_lmoments(data, "WEI")
plot_sffa_fit(results)

}
