% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-local.R
\name{data_local}
\alias{data_local}
\title{Fetch Local Package Data}
\usage{
data_local(csv_file)
}
\arguments{
\item{csv_file}{A character scalar containing the file name of a local dataset in
\verb{/inst/extdata}. Must be one of:
\itemize{
\item \code{"CAN-05BA001.csv"}: BOW RIVER AT LAKE LOUISE
\item \code{"CAN-05BB001.csv"}: BOW RIVER AT BANFF
\item \code{"CAN-07BE001.csv"}: ATHABASCA RIVER AT ATHABASCA
\item \code{"CAN-08MH016.csv"}: CHILLIWACK RIVER AT CHILLIWACK LAKE
\item \code{"CAN-08NH021.csv"}: KOOTENAI RIVER AT PORTHILL
\item \code{"CAN-08NM050.csv"}: OKANAGAN RIVER AT PENTICTON
\item \code{"CAN-08NM116.csv"}: MISSION CREEK NEAR EAST KELOWNA
}}
}
\value{
A dataframe with two columns:
\itemize{
\item \code{max}: A float, the annual maximum series observation, in m\eqn{^3}{^3}/s.
\item \code{year}: An integer, the corresponding year.
}
}
\description{
Fetch annual maximum series data for a hydrological monitoring station
from the package data directory.
}
\examples{
# Get data for the BOW RIVER AT BANFF (05BB001)
df <- data_local("CAN-05BB001.csv")

}
\seealso{
\code{\link[=data_geomet]{data_geomet()}}
}
