\name{Inverse}
\alias{read.web}
\alias{plot.web}
\alias{dotchart.web}

\title{Inverse analyis}
\description{
  Using inverse analysis in FEMME a .web file is generated which
  can be read and further processed with these functions
}

\usage{
read.web(webfile)

\method{plot}{web}(x, sizelab = 1.5, sizefig = 1.3, main="",sub="", log=FALSE,
legend=TRUE,\dots)

dotchart.web(x, log="", pch = 16, bg = par("bg"), color = par("fg"), 
                            lcolor = "gray", xlim = NULL, main = NULL, 
                            xlab = NULL, ylab = NULL,sizelab = 1.0, ...)
}
\arguments{
  \item{webfile}{File ending in .web generated by FEMME}
  \item{x}{object of class web created by \code{read.web}}
  \item{sizelab}{Size of labels}
  \item{sizefig}{Size of figure}
  \item{sub}{Subtitle}
  \item{log}{Arrow thickness on log scale}
  \item{legend}{Create legend}
  \item{pch}{Plot symbol}
  \item{bg}{the background color of plotting characters or symbols to be
          used}
  \item{color}{the color(s) to be used for points an labels}
  \item{lcolor}{the color(s) to be used for the horizontal lines}
  \item{xlim}{horizontal range for the plot}
  \item{main}{overall title for the plot, see \code{\link{title}}}
  \item{xlab, ylab}{axis annotations as in \code{title}.}
  \item{...}{Additional plot parameters}
}
\details{

}
\value{

\code{read.web} returns a web object

}
\references{Soetaert et al, 2002, Ecological  Modelling 151: 177-193}

\author{Karline Soetaert <k.soetaert@nioo.knaw.nl}
\note{Use at your own risk}


\examples{

## For examples see: vignette("femmeR")

}

\keyword{file}
\keyword{misc}
\keyword{hplot}

