% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_parse_sdmx_to_table.R
\name{fedstat_parse_sdmx_to_table}
\alias{fedstat_parse_sdmx_to_table}
\title{Parse sdmx raw bytes to data.frame}
\usage{
fedstat_parse_sdmx_to_table(data_raw)
}
\arguments{
\item{data_raw}{sdmx raw bytes}
}
\value{
data.frame
}
\description{
Parses sdmx raw bytes received in response to POST request.
This function is a wrapper around \code{readsdmx::read_sdmx} and \code{rsdmx::readSDMX},
in addition to reading data, automatically adds columns with values from lookup tables
}
\examples{
\dontrun{
# Get data filters identificators for week prices
# standardize names for DVFO and extract week numbers
# filter the data_ids to get data for week 21 and 22 of 2021
# for all goods and services for Russian Federation
# POST filters and download data in sdmx format
# Parse raw sdmx to data.frame
data <- fedstat_get_data_ids("37426") \%>\%
  fedstat_get_data_ids_special_cases_handle(
    filter_value_title_alias_lookup_table = data.frame(
      "filter_value_title" = "Dalnevostochnyj federalnyj okrug ( s 03.11.2018)",
      "filter_value_title_alias" = "Dalnevostochnyj federalnyj okrug"
    )
  ) \%>\%
  fedstat_data_ids_filter(
    filters = list(
      "Territory" = "Russian Federation",
      "Year" = "2021",
      "Period" = c(21, 22),
      "Types of goods and services" = "*"
    )
  ) \%>\%
  fedstat_post_data_ids_filtered() \%>\%
  fedstat_parse_sdmx_to_table()

# In this example names for DVFO are latinized for CRAN
# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
\seealso{
\code{\link{fedstat_parse_sdmx_to_table}}
}
