% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_CI.R
\name{shape_CI}
\alias{shape_CI}
\title{Shape Confidence Interval Calculation using Bootstrap Sampling}
\usage{
shape_CI(
  beta,
  a = 0.95,
  no = 5,
  Nsamp = 100,
  mode = "O",
  rotated = TRUE,
  scale = TRUE,
  lambda = 0,
  parallel = TRUE
)
}
\arguments{
\item{beta}{Array of sizes \eqn{n \times T \times N} describing \eqn{N}
curves of dimension \eqn{n} evaluated on \eqn{T} points}

\item{a}{confidence level (default = 0.95)}

\item{no}{number of principal components (default = 5)}

\item{Nsamp}{number of functions to generate (default = 100)}

\item{mode}{Open (\code{"O"}) or Closed (\code{"C"}) curves}

\item{rotated}{Optimize over rotation (default = \code{TRUE})}

\item{scale}{scale curves to unit length (default = \code{TRUE})}

\item{lambda}{A numeric value specifying the elasticity. Defaults to \code{0.0}.}

\item{parallel}{enable parallel processing (default = T)}
}
\value{
Return shape confidence intervals
}
\description{
This function computes Confidence bounds for shapes using elastic metric
}
\references{
J. D. Tucker, J. R. Lewis, C. King, and S. Kurtek, “A Geometric
Approach for Computing Tolerance Bounds for Elastic Functional Data,”
Journal of Applied Statistics, 10.1080/02664763.2019.1645818, 2019.

Tucker, J. D., Wu, W., Srivastava, A., Generative Models for
Function Data using Phase and Amplitude Separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\concept{bounds}
\keyword{bootstrap}
