% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aneurisk65}
\alias{aneurisk65}
\title{Subset of the AneuRisk65 benchmark data set}
\format{
A list with 2 components:
\describe{
\item{x}{A 65 x 1380 matrix containing, in each row, the evaluation grid
for each patient;}
\item{y}{A 65 x 3 x 1380 array containing, in each row, the values of the
first derivative of each of the 3D coordinates of the ICA centerline,
stored by a row in a matrix.}
}
}
\source{
This is a subset of the \href{https://mox.polimi.it/research-areas/statistics/}{AneuRisk65 benchmark data set} provided by the AneuRisk
project.
}
\usage{
aneurisk65
}
\description{
A data set containing the first derivative of the three-dimensional
coordinates of the centerline of the internal carotid artery of 65 patients.
}
\references{
\enumerate{
\item Sangalli, L.M., Secchi, P. and Vantini, S. (2014), \href{https://projecteuclid.org/journals/electronic-journal-of-statistics/volume-8/issue-2/AneuRisk65-A-dataset-of-three-dimensional-cerebral-vascular-geometries/10.1214/14-EJS938.full}{AneuRisk65: A dataset of three-dimensional cerebral vascular geometries},
Electronic Journal of Statistics, 8 (2), 1879-1890.
\item Sangalli, L.M., Secchi, P. and Vantini, S. (2014), \href{https://projecteuclid.org/journals/electronic-journal-of-statistics/volume-8/issue-2/Analysis-of-AneuRisk65-data-k-mean-alignment/10.1214/14-EJS938A.full}{Analysis of AneuRisk65 data: K-mean Alignment},
Electronic Journal of Statistics, 8 (2), 1891-1904.
}
}
\keyword{datasets}
