/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import jfm.model.Disease;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class DiseaseParser
extends JFMObjectParser {
    Types.DiseaseType id;

    public DiseaseParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("id", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("assoc", JFMObjectParser.optionalAttribute);
        this.registerAttribute("break", JFMObjectParser.optionalAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        this.id = Types.xmlToDiseaseType(this.getNamedAttribute("id"));
        Types.DiseaseType assoc = Types.DiseaseType.NONE;
        int minBreak = 0;
        if (this.attributeHasValue("assoc")) {
            assoc = Types.xmlToDiseaseType(this.getNamedAttribute("assoc"));
        }
        try {
            if (this.attributeHasValue("break")) {
                minBreak = Integer.parseInt(this.getNamedAttribute("break"));
            }
        }
        catch (NumberFormatException ex) {
            throw new XMLSyntaxException(ex.getMessage());
        }
        this.obj = new Disease(this.id, assoc, minBreak);
    }

    public String name() {
        return this.id.xmlname;
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String parsesNode() {
        return "disease";
    }

    public String toString() {
        return "DiseaseParser";
    }
}

