% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_pos_class_bal}
\alias{eval_pos_class_bal}
\title{Examine Balance for the Positive Class of a Model}
\usage{
eval_pos_class_bal(
  data,
  outcome,
  group,
  probs,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable}

\item{group}{Name of the sensitive attribute}

\item{probs}{Predicted probabilities}

\item{confint}{Logical indicating whether to calculate confidence intervals}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{bootstraps}{Number of bootstraps to use for confidence intervals}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Whether to print the results, default is TRUE}
}
\value{
A list containing the following elements:
\itemize{
\item Average predicted probability for Group 1
\item Average predicted probability for Group 2
\item Difference in average predicted probability
\item Ratio in average predicted probability
If confidence intervals are computed (\code{confint = TRUE}):
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the difference in average predicted probability
\item A vector of length 2 containing the lower and upper bounds of the 95\%
confidence interval for the ratio in average predicted probability
}
}
\description{
This function evaluates \emph{Balance for the Positive Class}, a fairness criterion
that checks whether the model assigns similar predicted probabilities across groups
among individuals whose true outcome is positive (i.e., \(Y = 1\)).
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.

# Evaluate Balance for Positive Class
eval_pos_class_bal(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred"
)
}
}
\seealso{
\code{\link{eval_neg_class_bal}}
}
