% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_curtail.R
\name{fabric_curtail}
\alias{fabric_curtail}
\title{Add a background or an overlay image to a preexisting canvas}
\usage{
fabric_curtail(cid, imgsrc, type = "background")
}
\arguments{
\item{cid}{the id of the canvas element}

\item{imgsrc}{the URL source of the image}

\item{type}{whether to use an image as a 'background' or as an 'overlay'}
}
\value{
a canvas with a background or overlay image
}
\description{
Add a background or an overlay image to a preexisting canvas
}
\examples{

if (interactive()) {

img <- "https://st.depositphotos.com/1642482/1904/i/950/depositphotos_19049237-stock-photo-leaf.jpg"

ui <- fluidPage(

use_fabric(),


fabric_shape(cid = "canvas123",
             shapeId = "tri1",
             shape = "Triangle",
             fill = "darkblue"),

fabric_curtail(cid = "canvas123",
             imgsrc = img,
             type = "background"

             )

)

server <- function(input, output) {}


shinyApp(ui = ui, server = server)

}
}
