% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download data from www.finance.yahoo.com}
\usage{
download_data(
  name = NULL,
  symbol = NULL,
  from = "1902-01-01",
  to = Sys.Date(),
  show_symbols = FALSE,
  path
)
}
\arguments{
\item{name}{A personal identifier for a stock, default \code{NULL}}

\item{symbol}{The stock's symbol, default \code{NULL}}

\item{from}{A date setting the lower data bound, default is \code{"1902-01-01"}}

\item{to}{A date setting the upper data bound, default is the current date \code{Sys.date()}}

\item{show_symbols}{A boolean determining whether all saved symbols should be printed, default \code{FALSE}}

\item{path}{A character, setting the data saving path}
}
\value{
No return value. Data is saved in "\code{path}/data".
}
\description{
Download data from www.finance.yahoo.com
}
\examples{
### download 21st century DAX data
download_data(name="dax",symbol="^GDAXI",from=as.Date("2000-01-03"),path=tempdir())
}
