% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fastest.R
\name{plot_fastest}
\alias{plot_fastest}
\title{Plot Fastest Lap}
\usage{
plot_fastest(
  season = get_current_season(),
  round = 1,
  session = "R",
  driver,
  color = "gear",
  race = lifecycle::deprecated()
)
}
\arguments{
\item{season}{number from 2018 to current season (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season selected) and defaults
to most recent.}

\item{session}{the code for the session to load Options are \code{'FP1'}, \code{'FP2'}, \code{'FP3'},
\code{'Q'}, \code{'S'}, \code{'SS'}, \code{'SQ'}, and \code{'R'}. Default is \code{'R'}, which refers to Race.}

\item{driver}{three letter driver code (see load_drivers() for a list).}

\item{color}{argument that indicates which variable to plot along the
circuit. Choice of \code{'gear'} or \code{'speed'}, default \code{'gear'}.}

\item{race}{number from 1 to 23 (depending on season selected) and defaults
to most recent.}
}
\value{
A ggplot object that indicates grand prix, driver, time and selected
color variable.
}
\description{
Creates a ggplot graphic that details the fastest lap for a driver in a race.
Complete with a gearshift or speed analysis.
}
\examples{
# Plot Verstappen's fastest lap (speed) from Bahrain 2023:
if (interactive()) {
  plot_fastest(2023, 1, "R", "VER", "speed")
}
}
