% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_data.R
\name{agg_data}
\alias{agg_data}
\title{Aggregates data}
\usage{
agg_data(data, cols = names(data), group_by = NULL,
  agg_fun = function(x) sum(x, na.rm = TRUE), group_by2 = NULL)
}
\arguments{
\item{data}{A data.frame.}

\item{cols}{Named character vector of column names.}

\item{group_by}{Vector of grouping column names.}

\item{agg_fun}{Function to use for aggregating.}

\item{group_by2}{Vector of grouping column names to use for delayed (post aggregation) calculation.}
}
\value{
An aggregated data.frame.
}
\description{
Aggregates data
}
\examples{
df = ez_data()
agg_data(df, c(Units = "units", Value = "value"))
agg_data(df["fct"])
agg_data(df[c("fct", "value")])
agg_data(df, "value", "fct")
agg_data(df, "value", c("fct", "year"))
agg_data(df, c(x = "year", y = "value"), c(x = "year"))
}
