% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_sat_curve.R
\name{p_sat_curve}
\alias{p_sat_curve}
\title{Create saturation curve}
\usage{
p_sat_curve(d_std, d_sat, man.units = FALSE)
}
\arguments{
\item{d_std}{Must be a dataframe that contains 'std.conc' and 'spec'.}

\item{d_sat}{Must be a dataframe that contains 'time', 'sub.conc' (substrate concentration), 'replicate', and 'spec' (spectral data).
If d_sat contains a fifth column, that fifth column will be assumed to be a normalization factor.
The rate of reacation will be divided by the values present in the fifth column.
The user will be prompted to name the unit of normalization, which will appear on the y-axis, if a fifth column is present.}

\item{man.units}{If 'man.units = TRUE', the user will be guided through a series of prompts to label the plot axes.
If 'man.units = FALSE', a plot will generated with generic axes titles.}
}
\value{
List containing new dataframe, regression model, and saturation curve.
}
\description{
Creates a dataframe and plot by applying the standard curve coefficients to the raw saturation data.
}
\details{
The spectral data is converted to concentration of standard.
The new dataframe contains the average slope (rate of reaction) and standard deviation for each replicate at each substrate concentration.
'p_sat_curve' plots the new dataframe with substrate concentration on the x-axis, and rate of reaction on the y-axis.
It asks the user to specify axis labels with the appropriate units. It predicts and reports Vmax and Km values.
It creates a list output containing the new dataframe, an additional new dataframe consisting of predicted curve fit values, the regression model, and the saturation curve plot.
}
\examples{
#If 'man.units = FALSE'
p_sat_curve(d_std, d_sat)
p_sat_curve(d_std, d_sat_n)

#If 'man.units = TRUE'
#Run 'p_sat_curve(d_std, d_sat)'.
#When prompted 'Substrate name:', type 'L-Leucine AMC' and press Enter.
#When prompted 'x-axis: What are the units of substrate concentration?', type '3' and press Enter.
#When prompted 'y-axis: What are the units of concentration?', type '3' and press Enter.
#When prompted 'y-axis: What are the units of time?', type '2' and press Enter.

#If 'man.units = TRUE'
#Run 'p_sat_curve(d_std, d_sat_n)'.
#When prompted 'Substrate name:', type 'L-Leucine AMC' and press Enter.
#When prompted 'x-axis: What are the units of substrate concentration?', type '3' and press Enter.
#When prompted 'y-axis: What are the units of concentration?', type '3' and press Enter.
#When prompted 'y-axis: What are the units of time?', type '2' and press Enter.
#When prompted 'Normalization unit:', type 'cell' and press Enter.

}
\author{
Christopher L. Cook and Andrew D. Steen
}
