% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezCutoffs.R
\name{ezCutoffs}
\alias{ezCutoffs}
\title{Fit Measure Cutoffs in SEM}
\usage{
ezCutoffs(model = NULL, data = NULL, n_obs = NULL, n_rep = 1000,
  fit_indices = c("chisq", "cfi", "tli", "rmsea", "srmr"),
  alpha_level = 0.05, normality = "assumed", missing_data = FALSE,
  bootstrapped_ci = FALSE, n_boot = 1000, boot_alpha = 0.05,
  boot_internal = FALSE, n_cores = NULL, ...)
}
\arguments{
\item{model}{\link[lavaan]{lavaan}-style Syntax of a user-specified model.}

\item{data}{A data frame containing the variables specified in model.}

\item{n_obs}{Specifies the number of observations. Only needed if no data frame is given. Can be given as a numeric vector representing the exact group sizes in multigroup analyses. In this case, the grouping variable needs to be called \code{"group"}.}

\item{n_rep}{Number of replications.}

\item{fit_indices}{Character vector, containing a selection of fit indices for which to calculate cutoff values. Only measures produced by \link[lavaan]{fitMeasures} can be chosen.}

\item{alpha_level}{Type I-error rate for the generated cutoff values: Between 0 and 1; 0.05 per default.}

\item{normality}{Specify distributional assumptions for the simulated data: Either \code{"assumed"} for normal distribution, or \code{"empirical"} for distributions based on the skewness and kurtosis values of the empirical data.}

\item{missing_data}{Specify handling of missing values: Either \code{FALSE} to generate complete data sets, or \code{TRUE} to generate data with the same number of missing values on the observed variables as in the empirical data.}

\item{bootstrapped_ci}{Specify whether a boostrapped confidence interval for the empirical model fit statistics should be drawn; default = FALSE.}

\item{n_boot}{Number of replications in bootstrap for confidence intervalls for empirical model fit statistics.}

\item{boot_alpha}{Type I-error rate choosen for the boostrap-confidence interval: Between 0 and 1; 0.05 per default.}

\item{boot_internal}{Whether to use the internal boostrap implemented in \code{bootstrapLavaan} or a standard implementation in the \link{boot} package. Defaults to \code{FALSE}}

\item{n_cores}{The number of cores to use. If \code{NULL} (the default) all available cores will be used.}

\item{...}{Additional arguments to pass to \link[lavaan]{lavaan}.}
}
\value{
An object of the class ezCutoffs, inspectable via \code{print}, \code{summary}, \code{plot}, and
\code{\link{compareFit}}
}
\description{
Calculate cutoff values for model fit measures used in structural equation modeling (SEM) by simulating and testing data sets (cf. Hu & Bentler, 1999 <doi:10.1080/10705519909540118>) with the same parameters (population model, number of observations, etc.) as the model under consideration.
}
\details{
\code{model} is expected in standard lavaan nomenclature. The typical pre-multiplication mechanism is supported, with the exception of vectors (see Examples). Multigroup models should instead be specified using the \code{group} argument. \cr\cr
If \code{data} is not specified, the program will generate data based on the given \code{model} and \code{n_obs}. A numeric vector would signify multiple groups and \code{group} needs to be set to "group" in this case. Otherwise, \code{n_obs} is disregarded. \cr\cr
\code{missing_data = TRUE} assumes that the data is missing completely at random. That, is missings should not be distributed unevenly in multigroup models, for instance.\cr\cr
\code{bootstrapped_ci = "TRUE"} Returns a nonparametric bootstrap confidence interval that quantifies the uncertainty within a data set with regard to the empirical fit indices. Larger sample sizes should, under ideal circumstances, have smaller confidence intervals. For more information see, e.g., Efron (1981; 1987). Bootstrapping uses the \code{library(boot)} and (if available) several CPUs to compute the confidence intervals via \code{snow}. \cr\cr
\code{...} allows the user to pass lavaan arguments to the model fitting procedure. Options include multigroup, repeated measures, growth curve, and multilevel models.
}
\examples{
## model specification examples

# simple uni-factorial model
model1 <- "F1 =~ a1 + a2 + a3 + a4 + a5"

# path model
model2 <- "m ~ 0.6*x1
           m ~ 0.5*x2
	   m ~ 0.4*x3
	   y ~ 0.7*m"

# two-factorial model with some exemplary pre-multiplications
model3 <- "F1 =~ NA*a1 + a2 + a3 + 0.8*a4 + a5
           F2 =~ b1 + start(0.8)*b2 + b3 + equal('F2 =~ b2')*b4 + b5
           F1 ~~ 0*F2"

## function call
out <- ezCutoffs(model = model1, n_obs = 1000, n_rep = 10, n_cores = 1)
\donttest{
out <- ezCutoffs(
  model = model1, n_obs = c(300, 400), n_rep = 9999, fit_indices = c("cfi.robust"),
  estimator = "MLM", group = "group", group.equal = c("loadings", "intercepts"), n_cores = 1
)
}

## retrieve output
summary(out)
plot(out)
}
\references{
Efron, D. (1981). Nonparametric estimates of standard error: The jackknife, the bootstrap and other methods, Biometrika,  68(3), 589-599. doi: 10.1093/biomet/68.3.589 \cr

Efron, B. (1987). Better bootstrap confidence intervals. Journal of the American statistical Association, 82(397), 171-185.

Hu, L. T., & Bentler, P. M. (1999). Cutoff criteria for fit indexes in covariance structure analysis: Conventional criteria versus new alternatives. Structural Equation Modeling: A Multidisciplinary Journal, 6(1), 1-55. doi: 10.1080/10705519909540118
}
\seealso{
\code{\link{compareFit}}
}
