% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onset_contingent_data.R
\name{make_switch_data}
\alias{make_switch_data}
\alias{make_switch_data.onset_data}
\title{Summarize data into time-to-switch from initial AOI.}
\usage{
make_switch_data(data, predictor_columns, summarize_by)

\method{make_switch_data}{onset_data}(data, predictor_columns = NULL,
  summarize_by = NULL)
}
\arguments{
\item{data}{The output of \code{make_onset_data}}

\item{predictor_columns}{Variables/covariates of interest when analyzing time-to-switch}

\item{summarize_by}{Should the data be summarized along, e.g., participants, items, etc.? 
If so, give column name(s) here. If left blank, will leave trials distinct. The former is 
needed for more traditional analyses (t.tests, ANOVAs), while the latter is preferable for 
mixed-effects models (lmer)}
}
\value{
A dataframe indicating initial AOI and time-to-switch from that AOI for each
  trial/subject/item/etc.
}
\description{
Take trials split by initial-AOI, and determine how quickly participants switch away from that AOI
}
\section{Methods (by class)}{
\itemize{
\item \code{onset_data}: 
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE
)
response_window <- subset_by_window(data, window_start_time = 15500, window_end_time = 21000, 
                                    rezero = FALSE)
inanimate_trials <- subset(response_window, grepl('(Spoon|Bottle)', Trial))
onsets <- make_onset_data(inanimate_trials, onset_time = 15500, 
                          fixation_window_length = 100, target_aoi='Inanimate')
                          
df_switch <- make_switch_data(onsets, predictor_columns = "MCDI_Total", 
             summarize_by = "ParticipantName")
plot(df_switch, "MCDI_Total")
                          
}

